﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;

namespace NVCC.Models
{
    [Serializable]
    public class AdditionalObject
    {
        public long AdditionalObjectId { get; set; }
        public int DisclosureId { get; set; }
        public DateTime DateOfObject { get; set; }
        
        public string ObjectType { get; set; }
        [NotMapped]
        [Display(Name = "Date of Object (MM/DD/YYYY)")]
        [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:M/d/yyyy}")]
        [DataType(DataType.Date, ErrorMessage = "Date of Object must be in MM/DD/YYYY format.")]
        [RegularExpression("^(([0]?[1-9]|1[0-2])/([0-2]?[0-9]|3[0-1])/[1-2]\\d{3})$", ErrorMessage = "Date of Object must be in MM/DD/YYYY format.")]
        public string ObjectDateString { get; set; }
        public string OtherTypeText { get; set; }
        [NotMapped]
        public bool Removed { get; set; }
    }
}
